function [struct_param, endo_ss] = calibrate_ss_competitive(estim_param, calib_targets)
% This function finds the structural parameters given a set of structural
% parameters to be estimated and calibration targets. 

est_par_names = {'beta', 'epsilon', 'alpha', 'eta', 'xi', 'lambda', 'nu', 'delta', 'gamma'}; 
for i = 1:length(est_par_names)
    eval([est_par_names{i} ' = estim_param.' est_par_names{i} ';']);
end
cal_tar_names = {'theta_ss', 'MS_o', 'R_o', 'L'};
for i = 1:length(cal_tar_names)
    eval([cal_tar_names{i} ' = calib_targets.' cal_tar_names{i} ';']);
end

beta    = estim_param.beta;
alpha    = estim_param.alpha;

r       = 1/beta - (1-delta);
beta_til= beta;

theta_n = theta_ss;
theta_o = theta_ss;
p       = 1;

psi     = (1-beta)/((1-beta)*eta + beta*theta_ss*(eta-1)) * p/(theta_ss^(eta-1));
mu_1_n  = p - eta*psi*theta_n^(eta-1);
mu_2_n  = lambda/(1-beta*(1-lambda))*mu_1_n;
mu_1_o  = mu_1_n;
mu_2_o  = mu_2_n;
s_o     = (R_o * p^(epsilon-1))^(1/epsilon);

% Find K and Y
K       = (alpha * (1-s_o) * ((1-s_o)/(1-s_o*(R_o/p)^((epsilon-1)/epsilon)))^(1/(epsilon-1)) * L^(1-alpha) / r)^(1/(1-alpha));
VA      = K^alpha * L^(1-alpha);
Y       = ((1-s_o)/(1-s_o*(R_o/p)^((epsilon-1)/epsilon)))^(epsilon/(epsilon-1)) * VA;

% Use Y guess: we know F_o*theta_o/o = MS_o
o       = R_o * Y / p;
F_o     = MS_o*o/theta_o; 
F_n     = (o - F_o*theta_o)/theta_n;
X_n     = (F_n*theta_n)/lambda;
X_o     = (F_o*theta_o)/lambda;

w       = r / (alpha/(1-alpha) * L/K);
varphi  = w / (L^nu);

% Use xi: I_n^(1-xi) = xi G_n^(1-xi) mu_2_n & I_n^xi G_n^(1-xi) = F_n theta_n
I2G_n   = (xi*mu_2_n)^(1/(1-xi));
I_n     = I2G_n^(1-xi) * F_n * theta_n;
G_n     = I_n / I2G_n;

I2G_o   = (xi * lambda/(1-beta*(1-lambda)) * beta/(1-beta) * psi * (eta-1) *theta_o^(eta))^(1/(1-xi));
I_o     = I2G_o^(1-xi) * F_o * theta_o;
G_o     = I_o/I2G_o;

C       = Y - delta * K - I_n - I_o - psi*theta_n^eta*F_n - psi*theta_o^eta*F_o;

prod_o  = theta_o * F_o;
prod_n  = theta_n * F_n;

st_param_names = {'beta', 'epsilon', 'alpha', 'eta', 'psi', 'lambda', 'nu', ...
                  'delta', 'gamma', 'xi', 'G_n', 'G_o', 's_o', 'varphi'};
for i = 1:length(st_param_names)
    eval(['struct_param.' st_param_names{i} ' = ' st_param_names{i} ';']);
end


endo_ss_names = {'p' 'I_o' 'I_n' 'F_o' 'F_n' 'X_o' 'X_n' 'theta_o' 'theta_n' 'prod_o' 'prod_n' ...
  'VA' 'mu_1_n' 'mu_2_n' 'mu_1_o' 'mu_2_o' 'o' 'Y' 'K' 'L' 'C' 'r' 'w' 'beta_til'};
for i = 1:length(endo_ss_names)
    eval(['endo_ss.' endo_ss_names{i} ' = ' endo_ss_names{i} ';']);
end

